/*--------------------------------------
	bundctls.c

	Mark Collins,   7/19/93 12:51:50
	handles the controls in the bundle editor segment
*/

#include "icon.h"

extern EventRecordPtr		fEventPtr;
extern word				fUserID;
extern char				tempStr[256];

word		ctlCount[] =   { 0, 8, 9, 8, 23, 6, 18};
handle		ctls[23];
Rect		bodyRect = { 84, 0, 316, 147};
Rect		countRect = {70, 216, 82, 278};
Rect		nullRect = { 0, 0, 0, 0};
long		CtlArray[7][23] = {
	{	0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L,
		0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L,
		0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L },
	{	0x1130L, 0x1140L, 0x1150L, 0x1160L, 0x1170L, 0x1180L, 0x1190L, 0x11A0L,
		0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L,
		0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L },
	{	0x1230L, 0x1240L, 0x1245L, 0x1250L, 0x1260L, 0x1270L, 0x1280L, 0x1290L,
		0x12A0L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L,
		0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L },
	{	0x1310L, 0x1320L, 0x1330L, 0x1335L, 0x1340L, 0x1345L, 0x1350L, 0x1360L,
		0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L,
		0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L },
	{	0x1420L, 0x1430L, 0x1431L, 0x1432L, 0x1433L, 0x1434L, 0x1435L, 0x1436L,
		0x1437L, 0x1440L, 0x1441L, 0x1442L, 0x1443L, 0x1444L, 0x1445L, 0x1446L,
		0x1447L, 0x1450L, 0x1460L, 0x1470L, 0x1480L, 0x1490L, 0x14A0L	},
	{	0x1530L, 0x1540L, 0x1550L, 0x1560L, 0x1570L, 0x1580L, 0x0000L, 0x0000L,
		0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L,
		0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L },
	{	0x1610L, 0x1620L, 0x1630L, 0x1631L, 0x1632L, 0x1633L, 0x1634L, 0x1635L,
		0x1636L, 0x1637L, 0x1644L, 0x1645L, 0x1646L, 0x1647L, 0x1650L, 0x1660L,
		0x1670L, 0x1680L, 0x0000L, 0x0000L, 0x0000L, 0x0000L, 0x0000L } };

/*  Reference for matchFlags
Bit     HexEq     Field
 0 -    0x0001   fileType
 1 -    0x0002   auxType
 2 -    0x0004   fileName
 3 -    0x0008   creation date
 4 -    0x0010   mod date
 5 -    0x0020   local access
 6 -    0x0040   net access
 7 -    0x0080   extended files
 8 -    0x0100   HFS Filetype
 9 -    0x0200   HFS Creator
10 -    0x0400   Option List
11 -    0x0800   EOF
*/
#pragma debug -1

void SwapCtls (word oldGroup, word newGroup, GrafPortPtr winP)
{
handle				temp;
word				j;
GrafPortPtr			oldP;

	if (oldGroup != newGroup) {
		for (j = 0; j < ctlCount[oldGroup]; j++) {
			HideControl(ctls[j]);
			DisposeControl(ctls[j]);
		}
		oldP = GetPort();
		SetPort(winP);
		EraseRect(&bodyRect);
		for (j = 0; j < ctlCount[newGroup]; j++) {
			temp = loadEdRes(CtlArray[newGroup][j], rControlTemplate);
			ctls[j] = (Handle) NewControl2(winP, 1, temp);
			DrawOneCtl(ctls[j]);
		}
	}
}

void StoreCtls(word Group, GrafPortPtr winP, OneDocDataPtr theDoc)
{
word				tVal;
long				lSize, hSize, fVal, fVal1;
char				*ltr;
morph				retVal, retVal2;

	switch (Group) {
		case 1:
			if (GetCtlValue(ctls[6])) {
				GetLETextByID(winP, 0x1130L, tempStr);
				theDoc->fileType = Dec2Int(&tempStr[1], (word) tempStr[0], 1);
			}
			if (GetCtlValue(ctls[7])) {
				GetLETextByID(winP, 0x1140L, tempStr);
				theDoc->auxType = Dec2Long(&tempStr[1], (word) tempStr[0], 1);
				GetLETextByID(winP, 0x1150L, tempStr);
				theDoc->auxMask = Dec2Long(&tempStr[1], (word) tempStr[0], 1);
			}
			theDoc->matchFlags = setMatchFlags(theDoc->matchFlags, ctls[6], 0x00000001L);
			theDoc->matchFlags = setMatchFlags(theDoc->matchFlags, ctls[7], 0x00000002L);
			break;

		case 2:
			if (GetCtlValue(ctls[6])) {
				GetLETextByID(winP, 0x1230L, tempStr);
				lSize = (long) tempStr[0] + 1;
				if (tempStr[0] == 0) {
					if (theDoc->fileNameHndl)
						DisposeHandle(theDoc->fileNameHndl);
					theDoc->fileNameHndl = 0L;
				}
				else {
					if (!theDoc->fileNameHndl)
					theDoc->fileNameHndl = NewHandle(lSize, fUserID, 0x8018, 0L);
					hSize = GetHandleSize(theDoc->fileNameHndl);
					if (hSize != lSize) {
						HUnlock(theDoc->fileNameHndl);
						SetHandleSize(lSize, theDoc->fileNameHndl);
					}
					BlockMove(tempStr, *theDoc->fileNameHndl, lSize);
				}
			}
			if (GetCtlValue(ctls[7])) {
				GetLETextByID(winP, 0x1240L, tempStr);
				theDoc->eof = Dec2Long(&tempStr[1], (word) tempStr[0], 1);
				theDoc->eofCompSpec = (GetCtlValue(ctls[2]) - 0x1301);
			}
			if (GetCtlValue(ctls[8])) {
				tVal = GetCtlValue(ctls[3]);
				theDoc->extMask = 0x8000;
				theDoc->compareValue = tVal ? 0x8000 : 0x0000;
			}
			theDoc->matchFlags = setMatchFlags(theDoc->matchFlags, ctls[6], 0x00000080L);
			theDoc->matchFlags = setMatchFlags(theDoc->matchFlags, ctls[7], 0x00000800L);
			theDoc->matchFlags = setMatchFlags(theDoc->matchFlags, ctls[8], 0x00000004L);
			break;

		case 3:
			if (GetCtlValue(ctls[6])) {
				theDoc->CcompareSpec = (GetCtlValue(ctls[0]) - 0x1301);
				retVal.lng = CallCtlDefProc(ctls[2], 0x8000, 0x00000000);
				retVal2.lng = CallCtlDefProc(ctls[2], 0x8000, 0x00000003);
				if (retVal2.cr[0] == 2)
					retVal.cr[0] += 12;
				theDoc-> CtimeRec.timebytes[2] = retVal.cr[0];
				retVal.lng = CallCtlDefProc(ctls[2], 0x8000, 0x00000001);
				theDoc-> CtimeRec.timebytes[1] = retVal.cr[0];
				retVal.lng = CallCtlDefProc(ctls[2], 0x8000, 0x00000002);
				theDoc-> CtimeRec.timebytes[0] = retVal.cr[0];
				retVal.lng = CallCtlDefProc(ctls[3], 0x8000, 0x00000000);
				theDoc-> CtimeRec.timebytes[5] = retVal.cr[0];
				retVal.lng = CallCtlDefProc(ctls[3], 0x8000, 0x00000001);
				theDoc-> CtimeRec.timebytes[4] = retVal.cr[0];
				retVal.lng = CallCtlDefProc(ctls[3], 0x8000, 0x00000002);
				theDoc-> CtimeRec.timebytes[3] = retVal.cr[0];
				theDoc->McompareSpec = (GetCtlValue(ctls[1]) - 0x1311);
			}
			if (GetCtlValue(ctls[7])) {
				retVal.lng = CallCtlDefProc(ctls[4], 0x8000, 0x00000000);
				retVal2.lng = CallCtlDefProc(ctls[4], 0x8000, 0x00000003);
				if (retVal2.cr[0] == 2)
					retVal.cr[0] += 12;
				theDoc-> MtimeRec.timebytes[2] = retVal.cr[0];
				retVal.lng = CallCtlDefProc(ctls[4], 0x8000, 0x00000001);
				theDoc-> MtimeRec.timebytes[1] = retVal.cr[0];
				retVal.lng = CallCtlDefProc(ctls[4], 0x8000, 0x00000002);
				theDoc-> MtimeRec.timebytes[0] = retVal.cr[0];
				retVal.lng = CallCtlDefProc(ctls[5], 0x8000, 0x00000000);
				theDoc-> MtimeRec.timebytes[5] = retVal.cr[0];
				retVal.lng = CallCtlDefProc(ctls[5], 0x8000, 0x00000001);
				theDoc-> MtimeRec.timebytes[4] = retVal.cr[0];
				retVal.lng = CallCtlDefProc(ctls[5], 0x8000, 0x00000002);
				theDoc-> MtimeRec.timebytes[3] = retVal.cr[0];
			}
			theDoc->matchFlags = setMatchFlags(theDoc->matchFlags, ctls[6], 0x00000008L);
			theDoc->matchFlags = setMatchFlags(theDoc->matchFlags, ctls[7], 0x00000010L);
			break;

		case 4:
			if (GetCtlValue(ctls[0])) {
				fVal = 0;      /* retval is the value */
				fVal1 = 0;     /* retval is the mask */
				/* read */
				fVal = setMatchFlags(fVal, ctls[13], 0x000000001L);
				fVal1 = setMatchFlags(fVal1, ctls[14], 0x000000001L);
				/* write */
				fVal = setMatchFlags(fVal, ctls[11], 0x000000002L);
				fVal1 = setMatchFlags(fVal1, ctls[12], 0x000000002L);
				/* invisible */
				fVal = setMatchFlags(fVal, ctls[9], 0x000000004L);
				fVal1 = setMatchFlags(fVal1, ctls[10], 0x000000004L);
				/* backup */
				fVal = setMatchFlags(fVal, ctls[5], 0x000000020L);
				fVal1 = setMatchFlags(fVal1, ctls[6], 0x000000020L);
				/* rename */
				fVal = setMatchFlags(fVal, ctls[3], 0x000000040L);
				fVal1 = setMatchFlags(fVal1, ctls[4], 0x000000040L);
				/* destroy */
				fVal = setMatchFlags(fVal, ctls[1], 0x000000080L);
				fVal1 = setMatchFlags(fVal1, ctls[2], 0x000000080L);
				/* stuff the parameter block with the correct values */
				theDoc->LAvalue = fVal & 0x0000FFFF;
				theDoc->LAmask = fVal1 & 0x0000FFFF;
			}
			theDoc->matchFlags = setMatchFlags(theDoc->matchFlags, ctls[0], 0x00000020L);
			break;

		case 5:
			if (GetCtlValue(ctls[4])) {
				ltr = (char *) &(theDoc->HFSfileType);
				GetLETextByID(winP, 0x1530L, tempStr);
				ltr[0] = tempStr[1];
				ltr[1] = tempStr[2];
				ltr[2] = tempStr[3];
				ltr[3] = tempStr[4];
			}
			if (GetCtlValue(ctls[5])) {
				ltr = (char *) &(theDoc->HFScreator);
				GetLETextByID(winP, 0x1540L, tempStr);
				ltr[0] = tempStr[1];
				ltr[1] = tempStr[2];
				ltr[2] = tempStr[3];
				ltr[3] = tempStr[4];
			}
			theDoc->matchFlags = setMatchFlags(theDoc->matchFlags, ctls[4], 0x00000100L);
			theDoc->matchFlags = setMatchFlags(theDoc->matchFlags, ctls[5], 0x00000200L);
			break;

		case 6:
			if (GetCtlValue(ctls[0])) {
				tVal = (GetCtlValue(ctls[1]) - 0x1620);
				setNetAccess(&theDoc->NAvalue, &theDoc->NAmask, tVal);
			}
			theDoc->matchFlags = setMatchFlags(theDoc->matchFlags, ctls[0], 0x00000040L);
			break;
	}
}

void FillCtls(word Group, GrafPortPtr winP, OneDocDataPtr theDoc)
{
word				tVal, len;
long				lSize, hSize, fVal, fVal1;
char				*ltr;
morph				retVal, retVal2;

	switch (Group) {
		case 1:
			setFlagCtl(theDoc->matchFlags, ctls[6], 0x00000001L);
			setFlagCtl(theDoc->matchFlags, ctls[7], 0x00000002L);
			if (GetCtlValue(ctls[6])) {
				FillLECtlWrd(theDoc->fileType, winP, 0x1130L);
			}
			else {
				FillLECtlWrd(0, winP, 0x1130L);
			}
			if (GetCtlValue(ctls[7])) {
				FillLECtlLng(theDoc->auxType, winP, 0x1140L);
				FillLECtlLng(theDoc->auxMask, winP, 0x1150L);
			}
			else {
				FillLECtlLng(0L, winP, 0x1140L);
				FillLECtlLng(0L, winP, 0x1150L);
			}
			break;

		case 2:
			setFlagCtl(theDoc->matchFlags, ctls[6], 0x00000080L);
			setFlagCtl(theDoc->matchFlags, ctls[7], 0x00000800L);
			setFlagCtl(theDoc->matchFlags, ctls[8], 0x00000004L);
			if (GetCtlValue(ctls[6])) {
				SetLETextByID(winP, 0x1230L, *theDoc->fileNameHndl);
			}
			else {
				tempStr[0] = 0;
				tempStr[1] = 0;
				SetLETextByID(winP, 0x1230L, tempStr);
			}
			if (GetCtlValue(ctls[7])) {
				FillLECtlLng(theDoc->eof, winP, 0x1240L);
				SetCtlValue(theDoc->eofCompSpec + 0x1301, ctls[2]);
			}
			else {
				FillLECtlLng(0L, winP, 0x1240L);
				SetCtlValue(0x1302, ctls[2]);
			}
			if (GetCtlValue(ctls[8])) {
				tVal = (theDoc->compareValue == 0x8000) ? 1 : 0;
			}
			else {
				tVal = 0;
			}
			SetCtlValue(tVal, ctls[3]);
			break;

		case 3:
			setFlagCtl(theDoc->matchFlags, ctls[6], 0x00000008L);
			setFlagCtl(theDoc->matchFlags, ctls[7], 0x00000010L);
			if (GetCtlValue(ctls[6])) {
				SetCtlValue(theDoc->CcompareSpec + 0x1301, ctls[0]);
				retVal.wrd[0] = theDoc-> CtimeRec.timebytes[2];
				retVal.wrd[1] = 0;
				if (retVal.wrd[0] > 12) {
					retVal.wrd[0] -= 12;
					retVal.lng = CallCtlDefProc(ctls[2], 0x8001, retVal.lng);
					retVal.wrd[0] = 2;
					retVal.wrd[1] = 3;
					retVal.lng = CallCtlDefProc(ctls[2], 0x8001, retVal.lng);
				}
				else {
					retVal.lng = CallCtlDefProc(ctls[2], 0x8001, retVal.lng);
					retVal.wrd[0] = 1;
					retVal.wrd[1] = 3;
					retVal.lng = CallCtlDefProc(ctls[2], 0x8001, retVal.lng);
				}
				retVal.wrd[0] = theDoc-> CtimeRec.timebytes[1];
				retVal.wrd[1] = 1;
				retVal.lng = CallCtlDefProc(ctls[2], 0x8001, retVal.lng);
				retVal.wrd[0] = theDoc-> CtimeRec.timebytes[0];
				retVal.wrd[1] = 2;
				retVal.lng = CallCtlDefProc(ctls[2], 0x8001, retVal.lng);
				retVal.wrd[0] = theDoc-> CtimeRec.timebytes[5];
				retVal.wrd[1] = 0;
				retVal.lng = CallCtlDefProc(ctls[3], 0x8001, retVal.lng);
				retVal.wrd[0] = theDoc-> CtimeRec.timebytes[4];
				retVal.wrd[1] = 1;
				retVal.lng = CallCtlDefProc(ctls[3], 0x8001, retVal.lng);
				retVal.wrd[0] = theDoc-> CtimeRec.timebytes[3];
				retVal.wrd[1] = 2;
				retVal.lng = CallCtlDefProc(ctls[3], 0x8001, retVal.lng);
			}
			if (GetCtlValue(ctls[6])) {
				SetCtlValue(theDoc->McompareSpec + 0x1311, ctls[1]);
				retVal.wrd[0] = theDoc-> MtimeRec.timebytes[2];
				retVal.wrd[1] = 0;
				if (retVal.wrd[0] > 12) {
					retVal.wrd[0] -= 12;
					retVal.lng = CallCtlDefProc(ctls[4], 0x8001, retVal.lng);
					retVal.wrd[0] = 2;
					retVal.wrd[1] = 3;
					retVal.lng = CallCtlDefProc(ctls[4], 0x8001, retVal.lng);
				}
				else {
					retVal.lng = CallCtlDefProc(ctls[4], 0x8001, retVal.lng);
					retVal.wrd[0] = 1;
					retVal.wrd[1] = 3;
					retVal.lng = CallCtlDefProc(ctls[4], 0x8001, retVal.lng);
				}
				retVal.wrd[0] = theDoc->MtimeRec.timebytes[1];
				retVal.wrd[1] = 1;
				retVal.lng = CallCtlDefProc(ctls[4], 0x8001, retVal.lng);
				retVal.wrd[0] = theDoc->MtimeRec.timebytes[0];
				retVal.wrd[1] = 2;
				retVal.lng = CallCtlDefProc(ctls[4], 0x8001, retVal.lng);
				retVal.wrd[0] = theDoc->MtimeRec.timebytes[5];
				retVal.wrd[1] = 0;
				retVal.lng = CallCtlDefProc(ctls[5], 0x8001, retVal.lng);
				retVal.wrd[0] = theDoc->MtimeRec.timebytes[4];
				retVal.wrd[1] = 1;
				retVal.lng = CallCtlDefProc(ctls[5], 0x8001, retVal.lng);
				retVal.wrd[0] = theDoc->MtimeRec.timebytes[3];
				retVal.wrd[1] = 2;
				retVal.lng = CallCtlDefProc(ctls[5], 0x8001, retVal.lng);
			}
			break;

		case 4:
			setFlagCtl(theDoc->matchFlags, ctls[0], 0x00000020L);
			if (GetCtlValue(ctls[0])) {
				fVal = theDoc->LAvalue;
				fVal1 = theDoc->LAmask;
			}
			else {
				fVal = 0L;
				fVal1 = 0L;
			}
			/* read */
			setFlagCtl(fVal, ctls[13], 0x000000001L);
			setFlagCtl(fVal1, ctls[14], 0x000000001L);
			/* write */
			setFlagCtl(fVal, ctls[11], 0x000000002L);
			setFlagCtl(fVal1, ctls[12], 0x000000002L);
			/* invisible */
			setFlagCtl(fVal, ctls[9], 0x000000004L);
			setFlagCtl(fVal1, ctls[10], 0x000000004L);
			/* backup */
			setFlagCtl(fVal, ctls[5], 0x000000020L);
			setFlagCtl(fVal1, ctls[6], 0x000000020L);
			/* rename */
			setFlagCtl(fVal, ctls[3], 0x000000040L);
			setFlagCtl(fVal1, ctls[4], 0x000000040L);
			/* destroy */
			setFlagCtl(fVal, ctls[1], 0x000000080L);
			setFlagCtl(fVal1, ctls[2], 0x000000080L);
			break;

		case 5:
			setFlagCtl(theDoc->matchFlags, ctls[4], 0x00000100L);
			setFlagCtl(theDoc->matchFlags, ctls[5], 0x00000200L);
			if (GetCtlValue(ctls[4])) {
				ltr = (char *) &(theDoc->HFSfileType);
				tempStr[0] = 4;
				tempStr[1] = ltr[0];
				tempStr[2] = ltr[1];
				tempStr[3] = ltr[2];
				tempStr[4] = ltr[3];
				SetLETextByID(winP, 0x1530L, tempStr);
			}
			else {
				tempStr[0] = 0;
				tempStr[1] = 0;
				SetLETextByID(winP, 0x1530L, tempStr);
			}
			if (GetCtlValue(ctls[5])) {
				ltr = (char *) &(theDoc->HFScreator);
				tempStr[0] = 4;
				tempStr[1] = ltr[0];
				tempStr[2] = ltr[1];
				tempStr[3] = ltr[2];
				tempStr[4] = ltr[3];
				SetLETextByID(winP, 0x1540L, tempStr);
			}
			else {
				tempStr[0] = 0;
				tempStr[1] = 0;
				SetLETextByID(winP, 0x1540L, tempStr);
			}
			break;

		case 6:
			setFlagCtl(theDoc->matchFlags, ctls[0], 0x00000040L);
			tVal = (GetCtlValue(ctls[1]) - 0x1620);
			putNetAccess(theDoc->NAvalue, theDoc->NAmask, tVal);
			break;
	}
}

void setNetAccess(long *netAccess, long *netMask, word subGroup)
{
long				access, mask;

	access = *netAccess;
	mask = *netMask;
	switch (subGroup) {
		case 1:   /* user summary */
			/* see folders */
			access = setMatchFlags(access, ctls[6], 0x00000001L);
			mask = setMatchFlags(mask, ctls[7], 0x00000001L);
			/* see files */
			access = setMatchFlags(access, ctls[4], 0x00000002L);
			mask = setMatchFlags(mask, ctls[5], 0x00000002L);
			/* make changes */
			access = setMatchFlags(access, ctls[2], 0x00000004L);
			mask = setMatchFlags(mask, ctls[3], 0x00000004L);
			/* folder owner */
			access = setMatchFlags(access, ctls[10], 0x00000080L);
			mask = setMatchFlags(mask, ctls[11], 0x00000080L);
			break;

		case 2:   /* world */
			/* see folders */
			access = setMatchFlags(access, ctls[6], 0x00000100L);
			mask = setMatchFlags(mask, ctls[7], 0x00000100L);
			/* see files */
			access = setMatchFlags(access, ctls[4], 0x00000200L);
			mask = setMatchFlags(mask, ctls[5], 0x00000200L);
			/* make changes */
			access = setMatchFlags(access, ctls[2], 0x00000400L);
			mask = setMatchFlags(mask, ctls[3], 0x00000400L);
			break;

		case 3:   /* Group */
			/* see folders */
			access = setMatchFlags(access, ctls[6], 0x00010000L);
			mask =   setMatchFlags(mask, ctls[7], 0x00010000L);
			/* see files */
			access = setMatchFlags(access, ctls[4], 0x00020000L);
			mask = setMatchFlags(mask, ctls[5], 0x00020000L);
			/* make changes */
			access = setMatchFlags(access, ctls[2], 0x00040000L);
			mask = setMatchFlags(mask, ctls[3], 0x00040000L);
			break;

		case 4:   /* Owner */
			/* see folders */
			access = setMatchFlags(access, ctls[6], 0x01000000L);
			mask = setMatchFlags(mask, ctls[7], 0x01000000L);
			/* see files */
			access = setMatchFlags(access, ctls[4], 0x02000000L);
			mask = setMatchFlags(mask, ctls[5], 0x02000000L);
			/* make changes */
			access = setMatchFlags(access, ctls[2], 0x04000000L);
			mask = setMatchFlags(mask, ctls[3], 0x04000000L);
			break;
	}
	*netAccess = access;
	*netMask = mask;
}

void putNetAccess(long netAccess, long netMask, word subGroup)
{
long				access, mask;

	access = netAccess;
	mask = netMask;
	switch (subGroup) {
		case 1:
			/* see folders */
			setFlagCtl(access, ctls[6], 0x00000001L);
			setFlagCtl(mask, ctls[7], 0x00000001L);
			setFlagCtl(access, ctls[4], 0x00000002L);
			setFlagCtl(mask, ctls[5], 0x00000002L);
			setFlagCtl(access, ctls[2], 0x00000004L);
			setFlagCtl(mask, ctls[3], 0x00000004L);
			setFlagCtl(access, ctls[10], 0x00000080L);
			setFlagCtl(mask, ctls[11], 0x00000080L);
			break;

		case 2:
			setFlagCtl(access, ctls[6], 0x00000100L);
			setFlagCtl(mask, ctls[7], 0x00000100L);
			setFlagCtl(access, ctls[4], 0x00000200L);
			setFlagCtl(mask, ctls[5], 0x00000200L);
			setFlagCtl(access, ctls[2], 0x00000400L);
			setFlagCtl(mask, ctls[3], 0x00000400L);
			break;

		case 3:
			setFlagCtl(access, ctls[6], 0x00010000L);
			setFlagCtl(mask, ctls[7], 0x00010000L);
			setFlagCtl(access, ctls[4], 0x00020000L);
			setFlagCtl(mask, ctls[5], 0x00020000L);
			setFlagCtl(access, ctls[2], 0x00040000L);
			setFlagCtl(mask, ctls[3], 0x00040000L);
			break;

		case 4:
			setFlagCtl(access, ctls[6], 0x01000000L);
			setFlagCtl(mask, ctls[7], 0x01000000L);
			setFlagCtl(access, ctls[4], 0x02000000L);
			setFlagCtl(mask, ctls[5], 0x02000000L);
			setFlagCtl(access, ctls[2], 0x04000000L);
			setFlagCtl(mask, ctls[3], 0x04000000L);
			break;
    }
}

void HandleBundleCtls(privateDataPtr privP)
{
integer				intWrd;
word				ctlHit, oldGroup, newGroup;
GrafPortPtr			winP;
OneDocDataPtr			docP;
BundleStructPtr		structP;
CtlRecHndl			ctlHndl;

	ctlHit = fEventPtr->wmTaskData4;
	winP = privP->winP;
	structP = *(privP->structH);
	docP = *(structP->oneDocHndl[privP->curDoc]);

	switch (ctlHit) {
		case 0x00001000L:  /* this is the match type popup */
			ctlHndl = GetCtlHandleFromID(winP, 0x1000L);
			newGroup = GetCtlValue(ctlHndl);
			oldGroup = privP->curGroup;
			StoreCtls(oldGroup, winP, docP);
			SwapCtls (oldGroup, newGroup, winP);
			FillCtls(newGroup, winP, docP);
			privP->curGroup = newGroup;

			break;

		case 0x00000FFEL:  /* show previous document */
			intWrd = privP->curDoc - 1;
			if (intWrd > -1) {
				StoreCtls(privP->curGroup, winP, docP);
				docP = *structP->oneDocHndl[privP->curDoc - 1];
				privP->curDoc--;
				FillCtls(privP->curGroup, winP, docP);
				drawBundleIcons(privP);
				printCount(privP);
			}
			break;

		case 0x00000FFFL:  /* show next document */
			intWrd = structP->oneDocCount - 1;
			if (intWrd > privP->curDoc) {
				StoreCtls(privP->curGroup, winP, docP);
				docP = *structP->oneDocHndl[privP->curDoc + 1];
				privP->curDoc++;
				FillCtls(privP->curGroup, winP, docP);
				drawBundleIcons(privP);
				printCount(privP);
			}
			break;

		case 0x00001620L:  /* network access specific */
			ctlHndl = GetCtlHandleFromID(winP, 0x1620L);
			newGroup = GetCtlValue(ctlHndl) - 1620;
			oldGroup = privP->curAccess;
			setNetAccess(&docP->NAvalue, &docP->NAmask, oldGroup);
			putNetAccess(docP->NAvalue, docP->NAmask, newGroup);
			privP->curAccess = newGroup;
			break;
    }
}

void openBundleWindow(privateDataPtr privP)
{
word				ctlHit, j, warning;
GrafPortPtr			winP;
OneDocDataPtr			docP;
BundleStructPtr		structP;
long				ctlHndl;
QDIconRecord			*iconH;
handle				temp, temp2;

	winP = privP->winP;
	structP = *(privP->structH);
	privP->curDoc = 0;
	privP->curGroup = 1;
	docP = *(structP->oneDocHndl[privP->curDoc]);

/* set up window with base set of match group controls */

	for (j = 0; j < ctlCount[privP->curGroup]; j++) {
		temp = loadEdRes(CtlArray[privP->curGroup][j], rControlTemplate);
		temp2 = (handle)NewControl2(winP, 1, temp);
		warning = toolerror();
		ctls[j] = temp2;
	}
	FillCtls(1, winP, docP);
	printCount(privP);

/* make sure our holes are zeroed to guarantee testing validity */
	privP->bunIcnCtlTemp = 0L;
	privP->bunIcnCtl = 0L;
	privP->docIcnCtlTemp = 0L;
	privP->docIcnCtl = 0L;
	privP->docSmIcnCtlTemp = 0L;
	privP->docSmIcnCtl = 0L;
/* then draw the icons */
	drawBundleIcons(privP);
}

void storeBundleWindow(privateDataPtr privP)
{
OneDocDataPtr			docP;
BundleStructPtr		structP;

	structP = *(privP->structH);
	docP = *(structP->oneDocHndl[privP->curDoc]);
	StoreCtls(privP->curGroup, privP->winP, docP);
}

handle createIcnCtl (word pos, GrafPortPtr winP, IconButtonTemplate **tempHand, QDIconRecord *iconP)
{
IconButtonTemplate		*buttonPtr;

	buttonPtr = *tempHand;
	buttonPtr->ctlTemplate.pCount = 7;
	buttonPtr->ctlTemplate.ID = 0x00000ff0L;
	switch (pos) {
		case 1:
			buttonPtr->ctlTemplate.rect.h1 = 6;
			buttonPtr->ctlTemplate.rect.h2 = 158;
			buttonPtr->ctlTemplate.rect.v1 = 8;
			buttonPtr->ctlTemplate.rect.v2 = 48;
			break;

		case 2:
			buttonPtr->ctlTemplate.rect.h1 = 160;
			buttonPtr->ctlTemplate.rect.h2 = 300;
			buttonPtr->ctlTemplate.rect.v1 = 8;
			buttonPtr->ctlTemplate.rect.v2 = 48;
			break;

		case 3:  /* never used */
			buttonPtr->ctlTemplate.rect.h1 = 6;
			buttonPtr->ctlTemplate.rect.h2 = 158;
			buttonPtr->ctlTemplate.rect.v1 = 50;
			buttonPtr->ctlTemplate.rect.v2 = 60;
			break;

		case 4:
			buttonPtr->ctlTemplate.rect.h1 = 160;
			buttonPtr->ctlTemplate.rect.h2 = 300;
			buttonPtr->ctlTemplate.rect.v1 = 50;
			buttonPtr->ctlTemplate.rect.v2 = 65;
			break;

	}
	buttonPtr->ctlTemplate.procRef = 0x07ff0001;
	buttonPtr->ctlTemplate.flag = 6;
	buttonPtr->ctlTemplate.moreFlags = 0x1000;
	buttonPtr->ctlTemplate.refCon = 0L;
	buttonPtr->iconRef = (Ref) iconP;
	return (Handle)NewControl2(winP, 0, buttonPtr);
}

void drawBundleIcons (privateDataPtr privP)
{
GrafPortPtr			winP;
QDIconRecord			**iconH;
OneDocDataPtr			docP;
BundleStructPtr		structP;

	winP = privP->winP;
	structP = *(privP->structH);
	docP = *(structP->oneDocHndl[privP->curDoc]);
/* first, blow away what is already there, making sure that invalid = 0L */

	if (privP->bunIcnCtlTemp) {
		DisposeHandle(privP->bunIcnCtlTemp);
		privP->bunIcnCtlTemp = 0L;
	}
	if (privP->bunIcnCtl) {
		HideControl(privP->bunIcnCtl);
		DisposeControl(privP->bunIcnCtl);
		privP->bunIcnCtl = 0L;
	}

	if (privP->docIcnCtlTemp) {
		DisposeHandle(privP->docIcnCtlTemp);
		privP->docIcnCtlTemp = 0L;
	}

	if (privP->docIcnCtl) {
		HideControl(privP->docIcnCtl);
		DisposeControl(privP->docIcnCtl);
		privP->docIcnCtl = 0L;
	}

	if (privP->docSmIcnCtlTemp) {
		DisposeHandle(privP->docSmIcnCtlTemp);
		privP->docSmIcnCtlTemp = 0L;
	}

	if (privP->docSmIcnCtl) {
		HideControl(privP->docSmIcnCtl);
		DisposeControl(privP->docSmIcnCtl);
		privP->docSmIcnCtl = 0L;
	}

/* then draw our new icon controls */
	iconH = (QDIconRecord **)loadIconRes(structP->iconID);

	if (iconH) {
		privP->bunIcnCtlTemp = NewHandle(sizeof(IconButtonTemplate), fUserID, 0x8018, 0L);
		privP->bunIcnCtl = createIcnCtl(1, winP, (IconButtonTemplate **)privP->bunIcnCtlTemp, *iconH);
	}

	iconH = (QDIconRecord **)loadIconRes(docP->iconID);
	if (iconH) {
		privP->docIcnCtlTemp = NewHandle(sizeof(IconButtonTemplate), fUserID, 0x8018, 0L);
		privP->docIcnCtl = createIcnCtl(2, winP, (IconButtonTemplate **)privP->docIcnCtlTemp, *iconH);
	}

	iconH = (QDIconRecord **)loadIconRes(docP->smIconID);
	if (iconH) {
		privP->docSmIcnCtlTemp = NewHandle(sizeof(IconButtonTemplate), fUserID, 0x8018, 0L);
		privP->docSmIcnCtl = createIcnCtl(4, winP, (IconButtonTemplate **)privP->docSmIcnCtlTemp, *iconH);
	}
}

void printCount(privateDataPtr privP)
{
	EraseRect(&countRect);
	MoveTo(216 ,79);
	sprintf(tempStr, "%u of %u", privP->curDoc + 1, (**privP->structH).oneDocCount);
	DrawCString(tempStr);
}
